/* dvd.c
 * Copyright (C) 1999 LinuxDVD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/fs.h>
#include <stdio.h>
#include <linux/cdrom.h>
#include <linux/version.h>
#include <errno.h>
#include "css-auth.h"

#if LINUX_VERSION_CODE > 131596
#define key1 key
#define key2 key
#endif


int encryption_status(int fd)
{
        dvd_struct d;

        d.copyright.type = DVD_STRUCT_COPYRIGHT;
        d.copyright.layer_num = 0;

        if (ioctl(fd, DVD_READ_STRUCT, &d)<0) {
                perror("DVD_READ_STRUCT");
                return 0;
        }
        if (!d.copyright.cpst) {
                fprintf(stderr, "Disc is not encrypted.\n");
		return 0;
	}
	return 1;
}

int dvd_auth(int fd, int agid, int step, char *buffer, int lba)
{
	dvd_authinfo ai;
	int i;

	memset(&ai, 0, sizeof(ai));
	ai.lsa.agid = agid;

	if (step == DVD_LU_SEND_AGID) {
		for (i = 0; i < 4; i++) {
			ai.type = DVD_INVALIDATE_AGID;
			ai.lsasf.agid = i;
			ioctl(fd, DVD_AUTH, &ai);
		}
		ai.type = DVD_LU_SEND_AGID;
	} else if (step == DVD_HOST_SEND_CHALLENGE) {
		ai.type = DVD_HOST_SEND_CHALLENGE;
		for (i = 0; i < 10; i++)
			ai.hsc.chal[9 - i] = buffer[i];
	} else if (step == DVD_LU_SEND_KEY1) {
		ai.type = DVD_LU_SEND_KEY1;
	} else if (step == DVD_LU_SEND_CHALLENGE) {
		ai.type = DVD_LU_SEND_CHALLENGE;
	} else if (step == DVD_HOST_SEND_KEY2) {
		ai.type = DVD_HOST_SEND_KEY2;
		for (i = 0; i < 5; i++)
			ai.hsk.key2[4 - i] = buffer[i];
	} else if (step == 2048) {
		dvd_struct s;
		s.type = DVD_STRUCT_DISCKEY;
		s.disckey.agid = agid;
		if (ioctl(fd, DVD_READ_STRUCT, &s) < 0)
			return -1;
		memcpy(buffer, s.disckey.value, 2048);
		return 0;
	} else if (step == DVD_LU_SEND_TITLE_KEY) {
		ai.type = DVD_LU_SEND_TITLE_KEY;
		ai.lstk.lba = lba;
	} else
		return -1;
	if (ioctl(fd, DVD_AUTH, &ai) < 0)
		return -1;
	if (step == DVD_LU_SEND_AGID)
		return ai.lsa.agid;
	if (step == DVD_LU_SEND_KEY1) {
		for (i = 0; i < 5; i++)
			buffer[i] = ai.lsk.key1[4 - i];
	}
	if (step == DVD_LU_SEND_CHALLENGE) {
		for (i = 0; i < 10; i++)
			buffer[i] = ai.hsc.chal[9 - i];
	}
	if (step == DVD_LU_SEND_TITLE_KEY) {
		for (i = 0; i < 5; i++)
			buffer[i] = ai.lstk.title_key[i];
	}
	return 0;
}

int selectfiles(const struct dirent *d)
{
	struct stat s;
	if (stat(d->d_name, &s))
		return 0;
	return S_ISREG(s.st_mode);

}
dirlist(char *dd)
{
	static struct dirent **namelist;
	int n, i;
	int f;
	int lba, lastlba = 0;
	struct stat s;

	n = scandir(dd, &namelist, selectfiles, alphasort);
	if (n < 0)
		perror("scandir");
	fprintf(stderr, "      Filename            LBA   Size (bytes)\n");
	fprintf(stderr, "____________________________________________\n");

	for (i=0; i<n; i++) {
		if ((f = open(namelist[i]->d_name, O_RDONLY)) > 0) {
			if (!fstat(f, &s)) {
				lba = 0;
				ioctl(f, FIBMAP, &lba);
#ifndef DONT_FIX_BUG
				/* FIBMAP *HACK* WILL PROBABLY FAIL! */
				if (lba < lastlba && lastlba > 2000000 &&
					lastlba < 4194304) {
					lba += 2097152;	/* >4GB */
				}
				if (lba < lastlba && lastlba > 4110000) {
					lba += 4194304; /* >8GB */
				}
#endif
				fprintf(stderr, "%14s %14d %14d\n",
					namelist[i]->d_name, lba, s.st_size);
				close(f);
				lastlba = lba;
			}
		}
		free(namelist[i]);
	}
	if (n)
		free(namelist);
}
unsigned char inbuf[2048];

int main(int argc, char **argv)
{
	int index, fd, outfile, lba, size, count;
	int agid, blocks, drive_index, dowhat;
	unsigned long long result;
	unsigned char Challenge[10], Key1[5], Key2[5], KeyCheck[5];
	unsigned char BusKey[5], DiscKey[2048];



	if (argc < 2) {
usage_error:
		fprintf(stderr, "usage: %s d -- directory of LBA offsets of files\n"
				"or:    %s g LBA filesize outputfile\n", argv[0], argv[0]);
		exit(1);
	}
	fd = open("/dev/cdrom", O_RDONLY /* | O_DIRECT */);

	if (tolower(argv[1][0]) == 'd') {
		if (chdir("/cdrom/video_ts/") < 0) {
			perror("chdir: /cdrom/video_ts/");
			exit(1);
		}
		dirlist(".");
		exit(0);
	}
	if (argc < 5)
		goto usage_error;

	if (tolower(argv[1][0]) != 'g')
		goto usage_error;
	lba = atoi(argv[2]);
	size = atoi(argv[3]);
	if (lba <= 0 || size <= 0)
		goto usage_error;
	if ((outfile = open(argv[4], O_CREAT|O_TRUNC|O_WRONLY, 402)) < 0) {
		perror(argv[4]);
		goto usage_error;
	}
	if (fd <= 0) {
		perror("/dev/cdrom");
		exit(1);
	}
	if (!encryption_status(fd))
		goto noauth;
	srand(time(NULL));
	for (index = 0; index < 10; index++)
		Challenge[index] = rand() & 0xff;
	for (dowhat = 0; dowhat < 2; dowhat++) {
		if ((agid = dvd_auth(fd, 0, DVD_LU_SEND_AGID, NULL, lba)) < 0)
			goto badauth;
		if (dvd_auth(fd, agid,
			DVD_HOST_SEND_CHALLENGE, Challenge, lba))
			goto badauth;
		if (dvd_auth(fd, agid, DVD_LU_SEND_KEY1, Key1, lba))
			goto badauth;
		for (drive_index = -1, index = 0; index < 32; index++) {
			CryptKey1(index, Challenge, Key2);
			if (memcmp(Key2, Key1, 5) == 0) {
				drive_index = index;
				break;
			}
		}
		if (drive_index < 0)
			goto badauth;
		if (dvd_auth(fd, agid, DVD_LU_SEND_CHALLENGE, Challenge, lba))
			goto badauth;
		CryptKey2(drive_index, Challenge, Key2);
		if (dvd_auth(fd, agid, DVD_HOST_SEND_KEY2, Key2, lba))
			goto badauth;
		memcpy(Challenge, Key1, 5);
		memcpy(Challenge + 5, Key2, 5);
		CryptBusKey(drive_index, Challenge, BusKey);
		if (dowhat == 0) {
			if (dvd_auth(fd, agid, 2048, DiscKey, lba))
				goto badauth;
			for (index = 0; index < 2048; index++)
				DiscKey[index] ^= BusKey[4 - (index % 5)];
		} else {
			if (dvd_auth(fd, agid,
				DVD_LU_SEND_TITLE_KEY, Key2, lba))
				goto badauth;
			for (index = 0; index < 5; index++)
				Key2[index] ^= BusKey[4 - index];
		}
	}
#ifdef WRITE_KEY_ONLY
	write(outfile, DiscKey, 2048);
	close(outfile);
	fprintf(stderr,"title_0x%02x%02x%02x%02x%02x\n", Key2[0],
		Key2[1], Key2[2], Key2[3], Key2[4]);
#else
	generate_decryption_key(DiscKey, Key2, Key1);
	fprintf(stderr,"Final Key: %02x%02x%02x%02x%02x\n", Key1[0],
		Key1[1], Key1[2], Key1[3], Key1[4]);
noauth:
	blocks = 1 + (size / 2048);
	result = (long long) lba * (long long) 2048;
	
	/* llseek didn't seem to work */
	lseek (fd, 0, SEEK_SET);
	for (index = 0; index < lba; index++)
		lseek (fd, 2048, SEEK_CUR);
	fprintf(stderr,"Writing to file \"%s\" from offset %Ld...\n", argv[4], result);
	for (index = 0; index < blocks; index++) {
		if(read(fd, inbuf, 2048) < 2048) {
			fprintf(stderr, "Short block!   Aborting...\n");
			exit(1);
		}
		if ((inbuf[20]&0xf0) == 0x90) {
			decipher_sector(inbuf, Key1);
			inbuf[20] = 0x81;
		}
		if (size - index * 2048 < 2048)
			count = size - index * 2048;
		else count = 2048;
		if (write(outfile, inbuf, count) < count) {
			perror("write");
			exit(1);
		}
		if (!(index & 0x3f))
			fprintf(stderr, "\rProgress...[%d/%d] %d%%", index, blocks, index * 100 / blocks);
	}
	fprintf(stderr, "\rDone.  %d blocks read, %d bytes written\n",  blocks, size);
#endif
	close(outfile);
	close(fd);
	exit(0);
badauth:
	fprintf(stderr, "DVD Authentication Failed...\n");
	exit(1);
}
