/* dvdinfo.c
 *
 * Copyright (C) 1999 LinuxDVD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * A program for getting and printing some info from the
 * DVD-ROM drive.
 */

#include <stdio.h>
#include <fcntl.h>
#include <linux/cdrom.h>
#include <sys/ioctl.h>
#include <errno.h>

#define DVD	"/dev/cdrom"

int GetASF(int fd)
{
	dvd_authinfo ai;

	ai.type = DVD_LU_SEND_ASF;
	ai.lsasf.agid = 3;
	ai.lsasf.asf = 0;

	if (ioctl(fd, DVD_AUTH, &ai)) {
		printf("GetASF failed\n");
		return 0;
	}

	printf("%sAuthenticated\n", (ai.lsasf.asf) ? "" : "not ");

	return 1;
}

char *book_type[16] = {
	"DVD-ROM", "DVD-RAM", "DVD-R", "Book3", "Book4", "Book5",
	"Book6", "Book7", "Book8", "Book9", "Book10",
	"Book11", "Book12", "Book13", "Book14", "Book15",
};

char *disc_size[16] = {
	"120mm", "80mm", "Size2", "Size3", "Size4", "Size5",
	"Size6", "Size7", "Size8", "Size9", "Size10",
	"Size11", "Size12", "Size13", "Size14", "Size15",
};

char *min_rate[16] = {
	"2.52Mbps", "5.04Mbps", "10.08Mbps", "Rate3", "Rate4", "Rate5",
	"Rate6", "Rate7", "Rate8", "Rate9", "Rate10",
	"Rate11", "Rate12", "Rate13", "Rate14", "Rate15",
};

char *track_path[2] = {
	"Parallel Track Path(PTP)", "Opposite Track Path(OTP)"
};

char *layer_type[16] = {
	"Type0", "Read-Only", "Recordable", "Type3", "Rewritable", 
	"Type5", "Type6", "Type7", "Type8", "Type9", "Type10",
	"Type11", "Type12", "Type13", "Type14", "Type15",
};

char *linear_density[16] = {
	"0.267um/bit", "0.293um/bit", "0.409-0.435um/bit", "LDens3",
	"LDens4", "LDens5", "LDens6", "LDens7", "LDens8", "LDens9", "LDens10",
	"LDens11", "LDens12", "LDens13", "LDens14", "LDens15",
};

char *track_density[16] = {
	"0.74um/track", "0.80um/track(DVD-R)", "TDens2", "TDens3",
	"TDens4", "TDens5", "TDens6", "TDens7", "TDens8", "TDens9", "TDens10",
	"TDens11", "TDens12", "TDens13", "TDens14", "TDens15",
};

int GetPhysical(int fd)
{
	dvd_struct d;
	int layer = 0, layers = 4;
	unsigned int i;

	d.physical.type = DVD_STRUCT_PHYSICAL;
	while (layer < layers) {
		d.physical.layer_num = layer;
	
		if (ioctl(fd, DVD_READ_STRUCT, &d)<0)
		{
			printf("Could not read Physical layer %d\n", layer);
			return 0;
		}

		layers = d.physical.layer[layer].nlayers + 1;

		printf("Layer %d\n", layer);
		if (layer == 0) {
			printf(" Book:           %s Version %d\n", book_type[d.physical.layer[layer].book_type],
				d.physical.layer[layer].book_version);
			printf(" Num Layers:     %d\n", layers);
			printf(" Layer Type:     %s\n", layer_type[d.physical.layer[layer].layer_type]);
			if (layers > 1)
				printf(" Track Path:     %s\n", track_path[d.physical.layer[layer].track_path]);
			printf(" Min Data Rate:  %s\n\n", min_rate[d.physical.layer[layer].min_rate]);
			i = d.physical.layer[layer].start_sector;
			printf(" Starting Sector:%#x (%s)\n", i, i == 0x31000 ? "DVD-RAM" : "DVD-ROM / DVD-R");
			printf(" End Sector(main)%#x\n", d.physical.layer[layer].end_sector);
			printf(" End Sector(L0)  %#x\n", d.physical.layer[layer].end_sector_l0);
		}
		printf(" BCA Flag:       %d\n", d.physical.layer[layer].bca);
		printf(" Disk Size:      %s\n", disc_size[d.physical.layer[layer].disc_size]);
		printf(" Linear Density: %s\n", linear_density[d.physical.layer[layer].linear_density]);
		printf(" Track Density:  %s\n", track_density[d.physical.layer[layer].track_density]);

		++layer;
	}

	return 1;
}

int GetCopyright(int fd)
{
	dvd_struct d;

	d.copyright.type = DVD_STRUCT_COPYRIGHT;
	d.copyright.layer_num = 0;
	
	if (ioctl(fd, DVD_READ_STRUCT, &d)<0)
	{
		printf("Could not read Copyright Struct\n");
		return 0;
	}
	if (d.copyright.cpst)
		printf("Disc is encrypted\n");
	else
		printf("Disc is unencrypted\n");
	d.copyright.rmi ^= 0xff;
	if (d.copyright.rmi & 1)
		printf("Disc is playable in Region 1\n");
	if (d.copyright.rmi & 2)
		printf("Disc is playable in Region 2\n");
	if (d.copyright.rmi & 4)
		printf("Disc is playable in Region 3\n");
	if (d.copyright.rmi & 8)
		printf("Disc is playable in Region 4\n");
	if (d.copyright.rmi &16)
		printf("Disc is playable in Region 5\n");
	if (d.copyright.rmi &32)
		printf("Disc is playable in Region 6\n");
	if (d.copyright.rmi &64)
		printf("Disc is playable in Region 7\n");
	if (d.copyright.rmi &128)
		printf("Disc is playable in Region 8\n");
	return 1;
}

int main(int ac, char **av)
{
	int fd;
	char *device = DVD;

	if (ac > 1)
		device = av[1];

	fd = open(device, O_RDONLY | O_NONBLOCK);

	if (fd < 0) {
		printf("unable to open dvd drive (%s).\n", device);
		return 1;
	}

	GetASF(fd);

	GetPhysical(fd);
	GetCopyright(fd);

	return 0;
}
