/**************************************************
* Test program for 3-way encryption to be used in *
* the steganographic file system.                 *
* (C) 1998 Carl van Schaik                        *
***************************************************/

#include "3way.h"
#include <stdlib.h>

extern int encrypt_3_way(word96, u_char*, word32);

void main()
{
  char *testBuf;
  int i,j;
  word96 key;

  testBuf = malloc(1024);

  for (i=0; i<1024; i++)
    testBuf[i] = i;

  key[0] = 0x4321;
  key[1] = 0x6789;
  key[2] = 0x1234;

  printf("3-way encryption/decryption test for steganographic file system\n");
  printf("(C) 1998 Carl van Schaik\n\n");


  // Test for lots a data

  for (i=1000;i<1024;i++) printf("% 4i ",testBuf[i]);
  printf("\n");

  encrypt_3_way(key, testBuf, 1024);

  for (i=1000;i<1024;i++) printf("% 4i ",testBuf[i]);
  printf("\n");

  decrypt_3_way(key, testBuf, 1024);

  for (i=1000;i<1024;i++) printf("% 4i ",testBuf[i]);
  printf("\n\n");

  // Test for little data

  for (j=1; j<12; j++)
    {
      for (i=0;i<j;i++) printf("% 4i ",testBuf[i]);
      printf("\n");

      encrypt_3_way(key, testBuf, j);

      for (i=0;i<j;i++) printf("% 4i ",testBuf[i]);
      printf("\n");

      decrypt_3_way(key, testBuf, j);

      for (i=0;i<j;i++) printf("% 4i ",testBuf[i]);
      printf("\n\n");
    }

  free(testBuf);
}
