/*****************************************************
*                                                    *
*  File encryption using the threeway block cipher   *
*                                                    *
*    This program is free to use, and since it was   *
*    not written in the US, does not violate any     *
*    US encryption export laws                       *
*                                                    *
*         Copyright (C) 1998 Carl van Schaik         *
*                                                    *
******************************************************/

#include "3way.h"
#include "getpass.c"
#include <stdlib.h>
#include <stdio.h>

#define maxBufLen  12288

extern int encrypt_3_way(word96, uchar*, word32);

FILE *inFile;        /* file with input data (plain or ciphertext)  */
FILE *outFile;       /* file for output data (plain or ciphertext)  */

int enc = 0;    /* we want encryption */
int dec = 0;    /* we want decryption */
int ser = 0;    /* we want to show key's hex value */
word96 pKey;

char   databuf[maxBufLen];
word32 datalen;

void getKey()
{
  char *buf;
  word96 tKey;
  int i=0;

  printf("  Every keypress is recorded, delete/backspace are taken as characters\n");
  printf("  Enter Key/Password : ");
  buf = getPass();

  tKey[0] = tKey[1] = tKey[2] = 1;

  while ((i < 128) && (buf[i] != '\n'))
    {
      tKey[0] += buf[i]*i;
      tKey[1] += (buf[1]<<2)*i;
      tKey[2] *= buf[i];
      i++;
    }

  pKey[0] = pKey[1] = pKey[2] = 0;

  encrypt_3_way(tKey,(uchar*)pKey,12);

  if (ser)
    {
#ifdef __alpha
      printf("Serial number = 0x%08x%08x%08x",pKey[0],pKey[1],pKey[2]);
#else
      printf("Serial number = 0x%08lx%08lx%08lx\n",pKey[0],pKey[1],pKey[2]);
#endif
    }
}

void ReadOptions(char *str)
{
  char ch;
  str++;
  while((ch = *str++) != '\0') {
    switch (ch) {
      case 'e': enc=1; break;
      case 'd': dec=1; break;
      case 's': ser=1; break;
      default: break;
    }
  }
} /* ReadOptions */

void getData()
{
  datalen = fread(databuf, 1, maxBufLen, inFile);
}

void putData()
{
  fwrite(databuf, 1, datalen, outFile);   
}

void main(int argc, char *argv[])
{
  argc--;
  argv++;

  printf("File encryption using 96-bit 3-way high security cipher\n");
  printf("This program is not subject to US encryption export laws\n");
  printf("Copyright (C) 1998 Carl van Schaik, UCT, South Africa\n");

  while (argc > 0 && argv[0][0] == '-' && argv[0][1] != '\0')
    {
      ReadOptions(*argv++);
      argc--;
    }

  inFile = fopen(*argv++, "rb"); argc--;
  if (inFile == NULL)
    {
      printf("Cannot open file %s\n",*--argv);
      enc = dec = 0;
    }

  outFile = fopen(*argv++, "wb"); argc--;
  if (outFile == NULL)
    {
      printf("Cannot open file %s\n",*--argv);
      enc = dec = 0;
    }

  if (enc)
    {
      getKey();

      printf("Encrypting...\r");
      fflush(stdout);

      datalen=maxBufLen;
      while (datalen == maxBufLen)
	{
	  getData();
	  encrypt_3_way(pKey, databuf, datalen);
	  putData();
	}
      if (datalen > 0)
	{
	  getData();
	  encrypt_3_way(pKey, databuf, datalen);
	  putData();
	}
      printf("Finished     \n");
    }
  else if (dec)
    {
      getKey();

      printf("Decrypting...\r");
      fflush(stdout);

      datalen=maxBufLen;
      while (datalen == maxBufLen)
	{
	  getData();
	  decrypt_3_way(pKey, databuf, datalen);
	  putData();
	}
      if (datalen > 0)
	{
	  getData();
	  decrypt_3_way(pKey, databuf, datalen);
	  putData();
	}
       printf("Finished     \n");
   }
  else
    {
      printf("Usage: ");
      printf("crypt -[e|d] [-s] inFile outFile\n");
      printf("  The key will be asked for before encryption/decryption\n");
      printf("  -e   Encrypt input File\n");
      printf("  -d   Decrypt input File\n");
      printf("  -s   Show serial number (Hex derivation of key)\n");
    }
}
