#ifndef HEADER_H
#define HEADER_H

#ifdef __GNUG__
#pragma interface
#endif

enum e_mode { stereo, joint_stereo, dual_channel, single_channel  };
enum e_sample_frequency { fourtyfour_point_one, fourtyeight, thirtytwo };


// Class for extraction information from a frame header:
class Header {
  static const uint32	frequencies[3];
  uint32		h_layer, h_protection_bit, h_bitrate_index,
			 h_padding_bit, h_mode_extension;
  e_mode		h_mode;
  e_sample_frequency	h_sample_frequency;
  uint32		h_number_of_subbands, h_intensity_stereo_bound;
  bool			h_copyright, h_original;
  Crc16			*crc;
  uint16		checksum;

  uint32		calculate_framesize ();
 public:
			Header (void) { crc = (Crc16 *)0; }
		       ~Header (void) { if (crc) delete crc; }
  int			read_header (AudioStream *, Crc16 **);
			// read a 32-bit header from the bitstream

  // functions to query header contents:
  uint32		layer (void) { return h_layer; };
  uint32		bitrate_index (void) { return h_bitrate_index; };
  e_sample_frequency	sample_frequency (void) { return h_sample_frequency; };
  uint32		frequency (void) { return frequencies[h_sample_frequency]; }
  static uint32	frequency (e_sample_frequency rate) { return frequencies[rate]; }
  e_mode		mode (void) { return h_mode; };
  bool			checksums(void){ return (!h_protection_bit) ? True : False; }
  bool			copyright(void){ return h_copyright; }
  bool			original(void){ return h_original; }
  bool			checksum_ok(void){ return (checksum==crc->checksum()) ? True : False; }
			// compares computed checksum with stream checksum

  // functions which return header informations as strings:
  const char *		layer_string (void);
  const char *		bitrate_string (void);
  const char *		sample_frequency_string (void);
  const char *		mode_string (void);

  uint32		number_of_subbands (void) { return h_number_of_subbands; };
			// returns the number of subbands in the current frame
  uint32		intensity_stereo_bound (void) {return h_intensity_stereo_bound; };
			// (Layer II joint stereo only)
			// returns the number of subbands which are in stereo mode,
			// subbands above that limit are in intensity stereo mode
};

#endif
