/*
   File: LayerData
   
   By: Alex Theo de Jong
   Created: February 1996

   Description:
   Place holder class for all layer data
 */

class LayerData {
  friend class Mpeg2Video;
 protected:
  VideoStream* input;     // bit input
  DisplayX11* display;
  Idct* idct;
  Synchronization* sync;  // Synchronization object

  // sequence header
  int intra_quantizer_matrix[64], non_intra_quantizer_matrix[64];
  int chroma_intra_quantizer_matrix[64], chroma_non_intra_quantizer_matrix[64];
  int mpeg2;
  int qscale_type,altscan;      // picture coding extension
  int pri_brk;                  // slice/macroblock
  int quant_scale;
  short block[12][64];
  int   sparse[12];

 public:
  int pict_scal;                // picture spatial scalable extension
  int scalable_mode;            // sequence scalable extension

 protected:
  // gethdr
  void getseqhdr(void);
  void getgophdr(void);
  void getpicturehdr(void);
  void ext_user_data(void);
  void sequence_extension(void);
  void sequence_display_extension(void);
  void quant_matrix_extension(void);
  void sequence_scalable_extension(void);
  void picture_display_extension(void);
  void picture_coding_extension(void);
  void picture_spatial_scalable_extension(void);
  void picture_temporal_scalable_extension(void);
  /* decode extra bit information */
  inline void ext_bit_info(void){ while (input->getbits(1)) input->flushbits(8); }
  // getpic
  void getMBs(int framenum);
  void macroblock_modes(int *pmb_type, int *pstwtype, int *pstwclass, 
                               int *pmotion_type, int *pmv_count, int *pmv_format, 
                               int *pdmv, int *pmvscale, int *pdct_type);
  void clearblock(int comp,int size);
  void addblock(int comp, int bx, int by, int dct_type, int addflag);
 public:
  LayerData(const char* windowtitle, Synchronization* s=0){ 
    sync=s; 
    idct=new Idct;
    input=0;
    display=new DisplayX11(windowtitle, s);
  }
  ~LayerData(){ 
    delete input;
    delete idct; 
    delete display; 
  }
  // gethdr
  int getheader();
  int getslicehdr(void);
  // getpic
  void getpicture(int framenum);
  void putlast();
 // getblk
  void getintrablock(int comp, int dc_dct_pred[]);
  void getinterblock(int comp);
  void getmpg2intrablock(int comp, int dc_dct_pred[]);
  void getmpg2interblock(int comp);
  // motion
  void motion_vectors(int PMV[2][2][2], int dmvector[2],
                      int mv_field_sel[2][2], int s, int mv_count, int mv_format,
                      int h_r_size, int v_r_size, int dmv, int mvscale);
  void motion_vector(int *PMV, int *dmvector,
                     int h_r_size, int v_r_size, int dmv, int mvscale, int full_pel_vector);
  void calc_DMV(int DMV[][2], int *dmvector, int mvx, int mvy);
  // recon
  void reconstruct(int bx, int by, int mb_type, int motion_type,
                   int PMV[2][2][2], int mv_field_sel[2][2], int dmvector[2], int stwtype);  
};
