/*
   File: util.hh

   Description:
   Small utilities that can be used throughout the API

   By: Alex Theo de Jong
   Created: September 1995
*/

#ifndef __util_hh
#define __util_hh

enum OnOff { On=1, Off=0 };

// Define true and false

#ifdef __GNUG__
#define True  1
#define False 0
#else
#undef True
#undef False
#undef TRUE
#undef FALSE
#undef true
#undef false
enum bool { FALSE=0, false=0, False=0, TRUE=1, true=1, True=1 };
#endif

struct Info {
  unsigned int mtu;
};


inline const char* itoa(int i){
  static char s[20];
  sprintf(s, "%d", i);
  return s;
}

inline const char* dtoa(double d){
  static char s[20];
  sprintf(s, "%g", d);
  return s;
}

inline const char* dec2hex(int i){
  static char s[20];
  sprintf(s, "%x", i);
  cout << s << "\n";
  return s;
}

typedef float		real;		// float should be enough
typedef unsigned	uint32;		// 32 Bit unsigned integer
// some compilers may need typedef unsigned long uint32; instead
//typedef int		int32;		// 32 Bit signed integer
// some compilers may need typedef long int32; instead
typedef unsigned short	uint16;		// 16 Bit unsigned integer
typedef short		int16;		// 16 Bit signed integer

#endif
