
#ifndef SUBBAND_LAYER_2_H
#define SUBBAND_LAYER_2_H



// class for layer II subbands in single channel mode:
class SubbandLayer2 : public Subband {
 protected:
  uint32 subbandnumber;

  uint32 allocation;
  uint32 scfsi;
  uint32 scalefactor1, scalefactor2, scalefactor3;
  bool	 grouping;
  uint32 codelength;
  uint32 quantizationsteps;
  real	 factor;

  uint32 groupnumber;
  uint32 samplenumber;
  real	 samples[3];
  real	 c, d;

  uint32 get_allocationlength (Header *);
  uint32 prepare_sample_reading (Header *, uint32, bool *, uint32 *, real *,
				 uint32 *, real *, real *);

public:
		SubbandLayer2 (uint32 subbandnumber);
  void		read_allocation (AudioStream *, Header *, Crc16 *);
  virtual void	read_scalefactor_selection (AudioStream *, Crc16 *);
  void		read_scalefactor (AudioStream *, Header *);
  bool		read_sampledata (AudioStream *);
  bool		put_next_sample (e_channels, SynthesisFilter *, SynthesisFilter * = NULL);
};


// class for layer II subbands in joint stereo mode:
class SubbandLayer2IntensityStereo : public SubbandLayer2 {
 protected:
  uint32 channel2_scfsi;
  uint32 channel2_scalefactor1, channel2_scalefactor2, channel2_scalefactor3;

 public:
       SubbandLayer2IntensityStereo (uint32 subbandnumber);
  void read_allocation (AudioStream *stream, Header *header, Crc16 *crc){
    SubbandLayer2::read_allocation (stream, header, crc);
  }
  void read_scalefactor_selection (AudioStream *, Crc16 *);
  void read_scalefactor (AudioStream *, Header *);
  bool read_sampledata (AudioStream *stream){
    return SubbandLayer2::read_sampledata (stream);
  }
  bool put_next_sample (e_channels, SynthesisFilter *, SynthesisFilter *);
};


// class for layer II subbands in stereo mode:
class SubbandLayer2Stereo : public SubbandLayer2 {
 protected:
  uint32 channel2_allocation;
  uint32 channel2_scfsi;
  uint32 channel2_scalefactor1, channel2_scalefactor2, channel2_scalefactor3;
  bool	 channel2_grouping;
  uint32 channel2_codelength;
  uint32 channel2_quantizationsteps;
  real	 channel2_factor;
  real	 channel2_samples[3];
  real	 channel2_c, channel2_d;
 public:
  SubbandLayer2Stereo (uint32 subbandnumber);
  void read_allocation (AudioStream *, Header *, Crc16 *);
  void read_scalefactor_selection (AudioStream *, Crc16 *);
  void read_scalefactor (AudioStream *, Header *);
  bool read_sampledata (AudioStream *);
  bool put_next_sample (e_channels, SynthesisFilter *, SynthesisFilter *);
};

#endif
