/*
   File: mpeg2const.hh

   By: Alex Theo de Jong
   Created: February 1996

   Description:
   Constants taken from the MPEG2 Standard, ISO/IEC 13818-1, 13818-2, and 13818-3
 */


#ifndef __mpeg2const_hh
#define __mpeg2const_hh

// Part 1

// const unsigned int MPEG2_TS_Packet_size      = 188;         // Page xvi
const unsigned int Sync_byte                 = 0x47;        // Page 17
const unsigned int Stuffing_byte             = 0xff;        // Page 21
const unsigned int Packet_start_code_prefix  = 0x000001;    // Page 24
const unsigned int Reserved                  = 0x00;        // Table 2-5,  Page 18
const unsigned int No_adapt_only_payload     = 0x01;
const unsigned int Only_adapt_no_payload     = 0x10;
const unsigned int Adapt_payload             = 0x11;
const unsigned int Program_stream_map        = 0xbc;        // Table 2-17, Page 37
const unsigned int Private_stream_1          = 0xbd;
const unsigned int Padding_stream            = 0xbe;
const unsigned int Private_stream_2          = 0xbf;

const unsigned int Program_Association_Table = 0x00;        // Page 18
const unsigned int Conditional_Access_Table  = 0x01;

const unsigned int Pack_start_code           = 0x000001ba;  // Page 34
const unsigned int System_start_code         = 0x000001bb;  // Page 35

// Part 2

const unsigned int Picture_start_code        = 0x00000100;  // Page 21
const unsigned int Slice_min_start           = 0x00000101;
const unsigned int Sequence_start_code       = 0x000001b3;
const unsigned int Slice_max_start           = 0x000001af;
const unsigned int User_start_code           = 0x000001b2;
const unsigned int Ext_start_code            = 0x000001b5;
const unsigned int Sequence_end_code         = 0x000001b7;
const unsigned int Gop_start_code            = 0x000001b8;
const unsigned int Iso_end_code              = 0x000001b9;

// Part 3

#endif // __mpeg2const_hh
