/*
   File: astream.cc

   By: Alex Theo de Jong
   Created: February 1996
*/

#include <stdio.h>
#include <fstream.h>
#include <sys/time.h>
#include <unistd.h>

#include "athread.hh"

#include "error.hh"
#include "debug.hh"
#include "util.hh"

#include "sync.hh"
#include "mpeg2const.hh"
#include "mpeg2buff.hh"

#include "astream.hh"

/*
 *
 * AudioStream
 *
 */

AudioStream::AudioStream(const char *filename) :
  word(0),  frames(0), bitindex(0), file(True), bytes(0)
{
  inputstream=new Mpeg2Input(filename, 8196);
  sync=0;
}

AudioStream::AudioStream(Mpeg2Buffer* input, Synchronization* s) :
  word(0), frames(0), bitindex(0), file(False), bytes(0)
{
  if (!(inputstream=input)){
    error("no audio input buffer");
    athr_exit(0);
  }
  sync=s;



}

AudioStream::~AudioStream(void){
  if (inputstream) inputstream->close();
  if (file) delete inputstream;
}

#if DEBUG

unsigned int AudioStream::get_bits(int n){ 
  for (; bytes && bitindex <= 24; bitindex += 8, bytes--)
    word|=(inputstream->getbyte() << (24 - bitindex));
  value=0;
  value=(word >> (32-n));
  bitindex-=n;
  word<<=n;
  return value;
}


bool AudioStream::get_header(unsigned int& headerstring){
  TRACER("bool AudioStream::get_header(unsigned int& headerstring)");
  if (bytes) inputstream->skipbytes(bytes);
  if (sync) sync->usedbytes(2, 4);  // 2 is audio ID, 4 is number of bytes
  if (inputstream->waitforbytes(4)!=4){
    TRACER("audio stream failed - exit");
    athr_exit(0);
    return False;
  }
  headerstring=inputstream->getbits32();
  inputstream->signal_buffer();
  while (((headerstring & 0xfff00000)!=0xfff00000) ){
    // In search mode for next header
    if (inputstream->waitforbytes(1)!=1){
      TRACER("audio stream failed - exit");
      athr_exit(0);
      return False;
    }
    headerstring<<=8;
    headerstring|=(inputstream->getbyte() & 0x000000ff);
    inputstream->signal_buffer();
  }
  return (headerstring) ? True : False;
}


bool AudioStream::read_frame(int bytesize){
  if ((bytes=inputstream->waitforbytes(bytesize))!=bytesize){
    TRACER("audio stream failed - exit");
    athr_exit(0);
    return False;
  }
  if (sync) sync->usedbytes(2, bytesize);  // 2 is audio ID, bytesize is number of bytes
  frames++;
  bitindex=0;
  return True;
}

#endif

