#include <stdio.h>
#include <math.h>
#include "fft.h"

#define Maxpts Max_fft
#define Numpts 1024

float x[Maxpts],y[Maxpts];

main(argc,argv)
int argc;
char *argv[];
{
long int ftime,time();
float period,halfamp;
float f1(),f2();
register int k,ntimes,npts;
if (argc >= 2) ntimes = atoi(argv[1]);
	else ntimes = 10;
if (argc >= 3) npts = atoi(argv[2]);
	else npts = Numpts;
if (argc >= 4) period = atof(argv[3]);
	else period = 8.;
if (argc >= 5) halfamp = atof(argv[4]);
	else halfamp = .50;

for (k=0; k <npts; k++) {
	x[k] = f1(k,period);
	y[k] = f2(k,period);
	}
ftime = clock();
for (k=0; k<ntimes/2; k++) {
	for_fft((float *) x,(float *) y,
		(float *) x,(float *) y,npts );
	inv_fft((float *) x,(float *) y,
		(float *) x,(float *) y,npts );
	}
ftime = clock() - ftime;
printf("%d point transform done in %.2f milliseconds.\n",
	npts,((float)ftime)/1.e3/ntimes);
exit(0);
}
